%% 
%       INSTRUCCIONES
%
% La mayoría de estos ejercicios se resolveran mediante la PDE-Toolbox.
% Para poder ejecutarlos mediante linea de comandos daremos los siguientes
% pasos
%
% - haremos nuestro calculo en la interfaz grafica de la PDE-Toolbox
% - guardaremos nuestro trabajo en un fichero
% - podemos ejecutar el fichero directamente desde la linea de comandos
% Matlab sin mas que escribir su nombre, como cualquier otra funcion.
%
% La PDE-Toolbox guarda el fichero como un fichero de una funcion 
% denominada 'pdemodel'. Lo mas elegante es cambiarle el nombre a la 
% funcion para que coincida con el nombre del fichero.
%

%%
% Ejercicio 1
%
% Resuelve mediante la PDE-Toolbox la ecuacion de Laplace en el dominio
% descrito por lo siguientes elementos (todos ellos rectangulos, en este
% caso), descritos en DRAW MODE:
%
% ___________________________________________________________
% |         |    R1     |     R2    |    R3     |    R4     |                                                 
% -----------------------------------------------------------
% | LEFT    |   -1.5    |    -1     |    -1     |    -1     |                                                 
% -----------------------------------------------------------
% | BOTTOM  |    -1     |    0.2    |   -0.4    |   -0.2    |                                                 
% -----------------------------------------------------------
% | WIDTH   |    3      |     2     |     2     |     2     |                                                 
% -----------------------------------------------------------
% | HEIGHT  |    2      |    0.2    |    0.2    |    0.4    |                                                 
% -----------------------------------------------------------
%
% El dominio se define mediante: R1 - R2 - R3 + R4
%
% Las condiciones de contorno (BOUNDARY MODE) son las siguientes:
%
% - perimetro de R1: Neumann (g = 0, q = 0).
% - Perímetro de R2: Dirichlet (h = 1, r = 1).
% - Perímetro de R3: Dirichlet (h = 1, r = 0).
%
% Las ecuaciones a resolver (PDE mode) 
% 
% - region R1-R4: Elliptic ( c = 1, f = 0).
% - region R4   : Elliptic ( c = 2, f = 0).
%
% Resuelve el problema para varios mallados (de menos a mas fino). Al final
% del ejercicio, exporta al espacio Matlab los arrays p,t,f, etc. La matriz
% de rigidez puede hallarse mediante la funcion assema
%
% [K,M,F1]=assema(p,t,c,a,f)
%
% Inspeccionando la funciona assema (edit assema) pueden encontrarse las
% coordenadas de los triangulos, por ejemplo.
%
% Este ejercicio tiene una clara interpretacion electrostatica. La energia
% del sistema puede hallarse mediante la operacion 
%
% energia = u*K*u',
%
% donde K es la matriz de rigidez y u es el array con la solucion. En esta
% interpretacion electrostatica, el rectangulo R4 juega el papel de un
% dielectrico.
%
% EJERCICIO: calcular la energia para varias posiciones del dielectrico
%

%%
% Ejercicio 2
%
% Vamos a calcular la fuerza que siente un cilindro dielectrico en el seno
% de un campo electrico no uniforme. El campo electrico no uniforme se
% generara con un electrodo en forma de punta eliptica.
%
% Hay que dibujar
%
% Rectangulo R1: left -1.5, bottom -1, width 3, height 2
%
% Elipse E1: X-center -1.5, Y-center 0.0, A-semiaxes 1.0, B-semiaxes 0.5,
% Rotation 0.
%
% Elipse E2: X-center 0.0, Y-center 0.0, A-semiaxes 0.35, B-semiaxes 0.35,
% Rotation 0.
%
% La formula que describe el dominio es: R1-E1+E2
%
% Las condiciones de contorno son: 
%
%  - elipse y recta x = -1.5: Dirichlet r=0.
%
%  - recta x = 1.5: Dirichlet r=0.
%
%  - Condiciones de Neumann en el resto ( q = 0, g = 0).
%
% La ecuacion diferencial a resolver:
%
% - en E2: eliptica ( c=5, f=0).
% - en el resto del dominio (c=1, f=0)
%
% Resuelve la ecuacion y calcula la energia. Repite el calculo
% intercambiando las permitividades del circulo y del fondo.
%
% Repite el calculo cambiando la posicion de E2: X-center 0.5. 
%